function [result,mX] = HAR(dep,expl,freq,nlag);

% reno@unisi.it, gennaio 2010
% estimates HAR model dep(t:t+nlag) = c + beta_1*dep(t-1:t-freq(1)) + ... + beta_k*expl(t-1:t-freq(1)) + ...
% uses nwest correction with 2*max(freq) orders
% INPUT
% input should all be column vectors
% dep -> dependent variables
% expl -> additional explanatory variable
%         use expl=[] if none
% freq -> the frequencies for HAR modelling
% nlag -> the horizon for forecasting
% OUTPUT
% result -> the structure with results

explX = [];
for j=1:length(freq)
    [temp, expl1]=aggregateAvg(dep,freq(j));
    explX = [explX, expl1];
end
if (~isempty(expl))
    for j=1:length(freq)
        [temp, expl1]=aggregateAvg(expl,freq(j));
        explX = [explX, expl1];
    end
end
result = nwest_extras(dep(1+nlag:end),[ones(size(dep(1+nlag:end))),explX(1:end-nlag,:)],max(freq)*2);
mX=[ones(size(dep(1+nlag:end))),explX(1:end-nlag,:)];
end
